/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEntityTick;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.levels.LevelHelper;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;

public class HorseFrostWalkerEnchantment
extends CustomEnchantment {
    public HorseFrostWalkerEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(Registries.HORSE_ARMOR).slots(EquipmentSlots.ARMOR).maxLevel(2).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 15);
    }

    public boolean m_6591_() {
        return true;
    }

    @AutoInstance
    public static class Handler {
        final Supplier<HorseFrostWalkerEnchantment> enchantment = Registries.HORSE_FROST_WALKER;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("HorseFrostWalker").comment("Creates a path of ice when walking over water on a horse.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnEntityTick.listen(this::freezeNearbyWater).addCondition(Condition.isServer()).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.entity)).addCondition(Condition.predicate(data -> data.entity instanceof Animal)).insertTo(group);
            OnPreDamaged.listen((Consumer)OnPreDamaged.CANCEL).addCondition(Condition.isServer()).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.target)).addCondition(Condition.predicate(data -> DamageSource.f_19309_.equals(data.source))).addCondition(Condition.predicate(data -> data.target instanceof Animal)).insertTo(group);
        }

        private void freezeNearbyWater(OnEntityTick.Data data) {
            assert (data.entity != null);
            int radius = this.enchantment.get().getEnchantmentSum(data.entity, EquipmentSlots.ARMOR) + 2;
            LevelHelper.freezeWater((Entity)data.entity, (double)radius, (int)60, (int)120, (boolean)false);
        }
    }
}

